/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_peek.c,v 1.33 2006/08/23 04:30:49 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib_types.h"
#include "mx__request.h"
#include "mx__error.h"
#include "mx__sleep.h"
#include "mx__endpoint.h"

int
mx__ipeek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		 mx_request_t *request);

mx_return_t
mx__peek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		uint32_t timeout, int is_wait_any,
		mx_request_t *request, uint32_t *result);

mx_return_t
mx__peek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		uint32_t timeout, int is_wait_any,
		mx_request_t *request, uint32_t *result)
{
  uint32_t ctxid = CTXID_FROM_MATCHING(endpoint, match_info);
  MX__EP_STATS_INC(endpoint, wait);

  /* Go through one iteration of mx__ipeek_common to see if a request 
   * is already done. */
  *result = mx__ipeek_common(endpoint, match_info, match_mask, request);
  if (*result == 0) {
    struct mx__wait_queue wq;
    wq.type.peek.match_info = match_info;
    wq.type.peek.match_mask = match_mask;
    wq.type.peek.is_wait_any = is_wait_any;
    wq.result = 0;
    mx__sleep_on_wait_queue(endpoint, &wq, timeout, &endpoint->peek_waiters, 
			    &endpoint->ctxid[ctxid].peek_queue_head);
    if (wq.result) {
      *request = wq.type.peek.request;
      *result = 1;
    }
    else {
      *result = 0;
    }
  } else {
    MX__EP_STATS_INC(endpoint, nonblocking_wait);
  }
  return MX_SUCCESS;
}


MX_FUNC(mx_return_t)
mx_peek(mx_endpoint_t endpoint, uint32_t timeout, mx_request_t *request,
	uint32_t *result)
{
  mx_return_t ret;

  if (endpoint->ctxid_bits)
    return mx__error(endpoint, "mx_peek", MX_NOT_SUPPORTED_WITH_CONTEXT_ID);

  MX__MUTEX_LOCK(&endpoint->lock);
  mx__luigi(endpoint);
  ret = mx__peek_common(endpoint, 0, 0, timeout, 0, request, result);
  MX__MUTEX_UNLOCK(&endpoint->lock);
  return ret;
}
